package unipotsdam.informatikkiste;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;

public class StartActivity extends Activity implements View.OnClickListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //Remove title bar
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);

        //Remove notification bar
        this.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.activity_main);

        setContentView(R.layout.activity_start);

        (findViewById(R.id.btn_start_solve)).setOnClickListener(this);
        findViewById(R.id.editText_start_code1).setOnFocusChangeListener(new DeleteOnClick());
        findViewById(R.id.editText_start_code2).setOnFocusChangeListener(new DeleteOnClick());
        findViewById(R.id.editText_start_code3).setOnFocusChangeListener(new DeleteOnClick());

        ((RiddleIdView)findViewById(R.id.riddleIdView)).setTouchEnabled(false);
        ((RiddleIdView)findViewById(R.id.riddleIdView)).setRiddleId(37);
    }

    @Override
    public void onClick(View v) {

        if(v.getId() == R.id.btn_start_solve ){
            int z1, z2, z3;
            try {
                z1 = Integer.parseInt(((EditText) findViewById(R.id.editText_start_code1)).getText().toString());
                z2 = Integer.parseInt(((EditText) findViewById(R.id.editText_start_code2)).getText().toString());
                z3 = Integer.parseInt(((EditText) findViewById(R.id.editText_start_code3)).getText().toString());
            }
            catch (NumberFormatException e){
                z1 = 0;
                z2 = 0;
                z3 = 0;
            }
            int solved = 0;
            if(z1 == getResources().getInteger(R.integer.start_z1_solution)){
                solved = 1;
                ((EditText)findViewById(R.id.editText_start_code1)).setBackgroundColor(getResources().getColor(R.color.colorSolved));
            }
            if(z2 == getResources().getInteger(R.integer.start_z2_solution)){
                solved = solved +1;
                ((EditText)findViewById(R.id.editText_start_code2)).setBackgroundColor(getResources().getColor(R.color.colorSolved));
            }
            if(z3 == getResources().getInteger(R.integer.start_z3_solution)) {
                solved = solved + 1;
                ((EditText) findViewById(R.id.editText_start_code3)).setBackgroundColor(getResources().getColor(R.color.colorSolved));
            }

            //Shortcut for Video-Testing
            if(z1 == 11 && z2 == 11 & z3 == 11){
                solved = 3;
            }

            solved = 3; //TODO: just for dev

            if(solved == 3){
                Intent intent = new Intent(this, VideoActivity.class);
                this.startActivity(intent);
                ((EditText) findViewById(R.id.editText_start_code1)).setBackgroundColor(getResources().getColor(R.color.colorBackgroundBright));
                ((EditText) findViewById(R.id.editText_start_code2)).setBackgroundColor(getResources().getColor(R.color.colorBackgroundBright));
                ((EditText) findViewById(R.id.editText_start_code3)).setBackgroundColor(getResources().getColor(R.color.colorBackgroundBright));

            }
            else{
                ((RiddleIdView)findViewById(R.id.riddleIdView)).setBackgroundColor(getResources().getColor(R.color.colorWrong));
                final Handler handler = new Handler();
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        ((RiddleIdView)findViewById(R.id.riddleIdView)).resetBackgroundColor();
                    }
                }, getResources().getInteger(R.integer.response_time));
            }
        }
    }

    private class DeleteOnClick implements View.OnFocusChangeListener{

        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            if(hasFocus){
                ((EditText)v).setText("");
            }
        }
    }

    @Override
    public void onResume(){
        super.onResume();
        ((EditText) findViewById(R.id.editText_start_code1)).setBackgroundColor(getResources().getColor(R.color.colorBackgroundBright));
        ((EditText) findViewById(R.id.editText_start_code2)).setBackgroundColor(getResources().getColor(R.color.colorBackgroundBright));
        ((EditText) findViewById(R.id.editText_start_code3)).setBackgroundColor(getResources().getColor(R.color.colorBackgroundBright));

        ((EditText) findViewById(R.id.editText_start_code1)).setText("?");
        ((EditText) findViewById(R.id.editText_start_code2)).setText("?");
        ((EditText) findViewById(R.id.editText_start_code3)).setText("?");
    }

}
